;*********************************
;* Jungle Jag - JagCode 500 Game *
;*********************************
;
; by Cedric Bourse, (a.k.a Orion_) [2007]
;
; http://onorisoft.info/
;
; This Source Code is licensed under the term of the following Creative Commons License:
; http://creativecommons.org/licenses/by-nc/3.0/
;
; You are free:
;  * to Share : to copy, distribute and transmit the work
;  * to Remix : to adapt the work
;
; Under the following conditions:
;  * Attribution. You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).
;  * Noncommercial. You may not use this work for commercial purposes.
;  * For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.
;  * Any of the above conditions can be waived if you get permission from the copyright holder.
;  * Nothing in this license impairs or restricts the author's moral rights.
;

	.text

LIANE_TILE_ID	.equ	80
LIANE_NUMBER	.equ	4

ITEM_TILE_ID	.equ	85
ITEM_NUMBER	.equ	5

HERO_TILE_ID	.equ	96

ENNEMY_TILE_ID	.equ	97
ENNEMY_NUMBER	.equ	3

STOP_TILE_ID	.equ	100

NOFENNEMY	.equ	25
NOFITEMS	.equ	10

LoadLevel:			; a0 = level struct
	bsr	UnSetSpriteList

;------------------
;- Recop Map Info -
;------------------

	lea	current_map,a1
	move.w	(a0)+,d0	; X
	move.w	(a0)+,d1	; Y
	move.w	d0,(a1)+
	move.w	d1,(a1)+
	move.l	(a0)+,(a1)+	; Layer0
	move.l	(a0)+,a1	; Layer1

	lea	cur_layer1,a0	; Recopy layer 1
	mulu	d1,d0		; (because it will be erased !)
	subq.w	#1,d0
.rcapmap:
	move.b	(a1)+,(a0)+
	dbra	d0,.rcapmap

	lea	current_map,a0

;---------------
;- Init Struct -
;---------------

	lea	EnnemyTable,a1
	lea	ItemsTable,a2
	moveq	#NOFENNEMY-1,d0
	moveq	#NOFITEMS-1,d1
	moveq	#-1,d2

.isc1:	move.w	d2,(a1)
	lea	8*2(a1),a1
	dbra	d0,.isc1

.isc2:	move.w	d2,(a2)
	lea	5*2(a2),a2
	dbra	d1,.isc2


;------------
; Vars Init -
;------------

	clr.w	ennemy_num
	clr.w	items_num
	clr.w	hero_mort
	clr.w	hero_jump
	clr.w	prev_jump
	clr.w	hero_liane
	clr.w	prev_liane
	clr.w	hero_moveliane
	clr.w	hero_anim
	clr.w	hero_wait
	clr.w	hero_move
	clr.w	hero_sens
	clr.w	scroll_x
	clr.w	nitems
	clr.w	win
	clr.w	game_over

	move.w	(a0),d0		; Board XSize
	lsl.w	#4,d0		; *16
	subi.w	#(320+32)/2,d0	; Half Screen plus Half Hero XSize
	move.w	d0,board_limit


;----------------------------------------------------------------
;- Render Level from Layer 0 / and Layer 1 for transparent Tile -
;----------------------------------------------------------------

	move.w	2(a0),d1	; Board YSize
	move.l	4(a0),a1	; Layer 0
	move.l	8(a0),a5	; Layer 1

	lea	LevelBuffer,a2	; Render Level in this buffer (op sprite)

	moveq	#0,d5
	move.w	(a0),d5		; X
	lsl.w	#4,d5		; *16
	move.l	d5,d6
	mulu	#15,d6		; to add each X line
	subi.l	#16,d5		; to add each tile line

	subq.w	#1,d1		; Y dbra
.renderY:
	move.w	(a0),d0
	subq.w	#1,d0		; X dbra
.renderX:
	moveq	#0,d3
	move.b	(a1)+,d3	; get tile number
	move.l	d3,d4
	andi.w	#15,d3		; tile X
	lsl.w	#8,d4		; tile Y
	andi.w	#$F000,d4	; (tileY>>4)*256*16 = ((tileY<<8))&0xF000 ?? ;)
	lsl.w	#4,d3		; tile X * 16
	add.w	d3,d4
	lea	tileset,a3
	adda.l	d4,a3
	movea.l	a2,a4		; save buffer position

	moveq	#16-1,d3	; copy one tile on board
.tile:	move.l	(a3)+,(a2)+
	move.l	(a3)+,(a2)+
	move.l	(a3)+,(a2)+
	move.l	(a3)+,(a2)+
	lea	240(a3),a3
	adda.l	d5,a2
	dbra	d3,.tile

	moveq	#0,d3
	move.b	(a5)+,d3	; get tile number in layer 1
	cmpi.b	#LIANE_TILE_ID,d3
	blt.s	.nl
	cmpi.b	#LIANE_TILE_ID+LIANE_NUMBER,d3
	bge.s	.nl

	lea	items,a3
	subi.w	#LIANE_TILE_ID,d3
	lsl.w	#8,d3		; 16*16
	adda.l	d3,a3
	movea.l	a4,a2		; restore buffer position

	moveq	#16-1,d3	; copy one tranparent tile on board
.Ttile:
	moveq	#16-1,d4
.TtilX:
	tst.b	(a3)+		; if black pixel
	beq.s	.nTl		; skip it
	move.b	-1(a3),(a2)	; else recop
.nTl:	addq.l	#1,a2
	dbra	d4,.TtilX
	adda.l	d5,a2
	dbra	d3,.Ttile

.nl:
	lea	16(a4),a2	; next tile

	dbra	d0,.renderX

	adda.l	d6,a2		; next line of tile
	dbra	d1,.renderY

;-------------------------------------------
;- Detect Hero/Ennemies/Items from Layer 1 -
;- Make Sprite List and Fill Structs Infos -
;-------------------------------------------

	movea.l	a0,a6

	bsr	InitSpriteList

	; First Sprite is the 16bits background
	moveq	#0,d0		; X
	move.w	#256,d1		; Y
	move.w	#320,d2		; X Size
	move.w	#240,d3		; Y Size
	move.l	#Background,d4	; Level Gfx Data
	bsr	AddSprite

	; First Sprite is the Level Board
	moveq	#0,d0		; X
	moveq	#0,d1		; Y
	move.w	(a6),d2		; X Size
	move.w	2(a6),d3	; Y Size
	lsl.w	#4,d2		; 16*16 Tiles
	lsl.w	#4,d3
	move.l	#LevelBuffer,d4	; Level Gfx Data
	bsr	AddSprite8

	moveq	#2,d7		; Sprite ID counter [ADD -1 HERE IF NO BACKGROUND]
	lea	EnnemyTable,a3	; Structs
	lea	ItemsTable,a4
	lea	EnnemyInfo,a5

	move.l	8(a6),a2	; Layer 1

	moveq	#0,d1		; Y
.spriteY:
	moveq	#0,d0		; X
.spriteX:
	movem.w	d0-d1,-(a7)

	moveq	#0,d2
	move.b	(a2)+,d2	; Get Tile ID

	lsl.w	#4,d0		; X * 16
	lsl.w	#4,d1		; Y * 16

	cmpi.b	#ITEM_TILE_ID,d2
	blt.s	.ni
	cmpi.b	#ITEM_TILE_ID+ITEM_NUMBER,d2
	bge.s	.ni

	; AddItem in struct only

	addq.w	#1,nitems

	subi.w	#ITEM_TILE_ID,d2
	move.w	d7,(a4)+	; Sprite ID
	move.w	d2,(a4)+	; Item ID
	move.w	d0,(a4)+	; X (Item Position on Map)
	move.w	d1,(a4)+	; Y
	clr.w	(a4)+		; Not Taken

	moveq	#0,d4
	move.w	d2,d4
	moveq	#16,d2		; All Items are 16x16
	moveq	#16,d3
	addq.w	#LIANE_NUMBER+1,d4	; Skip Liane + Coeur
	lsl.w	#8,d4		; Items Gfx Size (16*16 = 256)
	add.l	#items,d4	; Gfx

	bra.s	.Add

.ni:
	cmpi.b	#ENNEMY_TILE_ID,d2
	blt.s	.ne
	cmpi.b	#ENNEMY_TILE_ID+ENNEMY_NUMBER,d2
	bge.s	.ne

	; AddEnnemy

	subi.w	#ENNEMY_TILE_ID,d2
	lsl.w	#3,d2		; EnnemyInfo Struct

	moveq	#0,d3		; Fill Ennemy Structure
	move.w	d7,(a3)+	; Sprite ID
	move.w	d0,(a3)+	; X (Ennemy Position on Map)
	move.w	d1,(a3)+	; Y
	move.w	d2,(a3)+	; Ennemy Type ID * 8
	move.w	d3,(a3)+	; sens
	move.w	d3,(a3)+	; anim
	move.w	last_stop,(a3)+	; xstart (last stop position)
	move.w	d0,(a3)+	; xend (ennemy position)
	addq.w	#1,ennemy_num

	move.l	0(a5,d2.w),d4	; Gfx
	move.w	6(a5,d2.w),d3	; Y Size
	move.w	4(a5,d2.w),d2	; X Size

	bra.s	.Add

.ne:
	cmpi.b	#STOP_TILE_ID,d2
	bne.s	.ns

	move.w	d0,last_stop	; Save X position of the STOP Tile

	bra.s	.n

.ns:
	cmpi.b	#HERO_TILE_ID,d2
	bne.s	.n

	; AddHero

	move.w	d7,hero_sid	; Sprite ID
	move.w	d0,hero_x	; Hero Position on Map
	move.w	d1,hero_y
	move.w	d0,hero_ox
	move.w	d1,hero_oy
	moveq	#32,d2		; X Size
	moveq	#31,d3		; Y Size
	move.l	#hero,d4	; Gfx

	; Add a Sprite
.Add:
	addi.w	#16,d1		; Size of a Tile
	sub.w	d3,d1		; Sub Y Size to Y
	bsr	AddSprite8

	addq.w	#1,d7		; Sprite ID ++
.n:
	movem.w	(a7)+,d0-d1

	addq.w	#1,d0
	cmp.w	(a6),d0
	bne	.spriteX

	addq.w	#1,d1
	cmp.w	2(a6),d1
	bne	.spriteY

;-- Add coeur

	moveq	#COEUR_X,d0	; X
	move.w	#COEUR_Y,d1	; Y
	moveq	#16,d2		; X Size
	moveq	#16,d3		; Y Size
	move.l	#items+(16*16*4),d4	; Level Gfx Data

	move.w	d7,coeur_sid
	move.w	coeur,d5
	subq.w	#1,d5
.readdcoeur:
	movem.l	d0-d5,-(a7)
	bsr	AddSprite8
	movem.l	(a7)+,d0-d5
	addi.w	#16,d0
	dbra	d5,.readdcoeur

	bsr	EndSpriteList
	bsr	SetSpriteList

	rts
